/*********************************************************************/
/* Project Name: IIC_Master.mcp                                      */
/* Source fle name: IIC_Master.c                                     */
/*********************************************************************/
/* Copyright (C) 2007 Freescale Semiconductor, Inc.                  */
/* All Rights Reserved                                               */
/*********************************************************************/
/*********************************************************************/
/* Hands on training for QE128 MCU's                                 */
/* Module: IIC                                                       */
/* The firmware was developed and tested on CodeWarrior 6.0 version  */
/*                                                                   */
/* Description: Once the IIC module is configured, the master will   */
/* send the slave a counter value. The counter value will be display */
/* in both boards (Master and Slave)                                 */
/*********************************************************************/
/*                                                                   */
/* Date: 12/03/2007                                                  */
/* Ulises Corrales Salgado                                           */
/* Application Engineer                                              */
/* RTAC Americas                                                     */
/*********************************************************************/                                                                      


#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */

typedef unsigned char UINT8;
typedef unsigned int UINT16;

UINT8 last_byte = 0;
UINT8 counter = 0;
UINT8 last_byte_to_rec = 0;
UINT8 add_cycle = 0;
UINT8 count = 0;
UINT8 rec_count = 0;
UINT8 num_to_rec = 0;
UINT8 bytes_to_trans = 0;
UINT8 IIC_Data[9];
UINT8 IIC_Rec_Data[9];
UINT8 IIC_TX_Data[9];


/*********************************************************************/
/*  Function declarations                                            */
/*********************************************************************/

void MCU_Init(void) {
  
  SOPT1 = 0x23;          /* Watchdog disable */  
  SCGC1 = 0x08;          /* Bus Clock to the IIC2 module is enabled */
}

void GPIO_Init(void) { 
  
  PTHPE = 0xC0;          /* Enable Pull ups on PTH7 and PTH6 pins */
  PTCDD = (UINT8) (PTCD | 0x3F);          /* Configure PTC0-PTC6 as outputs */
  PTEDD = (UINT8) (PTED | 0xC0);          /* Configure PTE6 and PTE7 pins as outputs */
  PTCD = 0x3F;           /* Put 1's in port C in order to turn off the LEDs */
  PTED = 0xC0;           /* Put 1's in port E port in order to turn off the LEDs */
}


void IIC_configuration (void) {
 
  IIC2F = 0x09;         /* Multiply factor of 1. SCL divider of 32 */
  IIC2C1  = 0xC0;       /* Enable IIC module and interrupts */
} 

void Delay (UINT16 c) {    /* This delay function is used to spend some time */
                           /* before sending the next byte */
  UINT16 i = 0;
  
  for (i; i<=c; i++) {
  }
}

/*********************************************************************/
/*  Function used as Master                                          */
/*********************************************************************/

void Master_Read_and_Store(void) {

  if (rec_count == num_to_rec) {

  last_byte_to_rec = 2;
}

  IIC_Rec_Data[rec_count] = IIC2D;
  rec_count++;
}


void Master_Transmit(UINT8 a, UINT8 b) {   /* This function transmits commands to a Slave */

	last_byte = 0;            /* Initialize variables to 0 */
	count = 0;
 
  bytes_to_trans = a;       /* Initialize Data Array with Commands */
  num_to_rec =  b;
  
  IIC2C1_TX = 1;            /* Set TX bit for Address cycle */
  IIC2C1_MST = 1;           /* Set Master Bit to generate a Start */
  
  IIC2D = 0xAA;             /* Send Address data LSB is R or W for Slave */
}


void Master_Receive() {
  
  rec_count = 0;            /* Initialize variables to 0 */
  last_byte_to_rec = 0;
  last_byte = 0;            
  count = 0;
  num_to_rec = 0;
  
  IIC2C1_TXAK =0;
  IIC2C1_TX = 1;            /* Set TX bit for Address cycle */
  IIC2C1_MST = 1;           /* Set Master Bit to generate a Start */
  add_cycle = 1;            /* This variable sets up a master rec in the ISR */
  IIC2D = 0xAB;             /* Send Address data LSB is R or W for Slave */
}


/*********************************************************************/
/*  Function used as Slave                                           */
/*********************************************************************/

void Slave_Read_and_Store(void) {

  if (rec_count == num_to_rec) {

  last_byte_to_rec = 2;
}

  IIC_Rec_Data[rec_count] = IIC2D;
  rec_count++;
  if (rec_count == num_to_rec) {
  rec_count = 0;
  }
}


void SRW(void) {
							        
  if (IIC2S_SRW) {      /* Check for Slave Rec or transmit */
          
  IIC2C1_TX = 1;        /* Set Tx bit to begin a Transmit */
  IIC2D = IIC_TX_Data[count];
  count++;
  } 
  
  else {
  
  IIC2C1_TX = 0;        /* An acknowledge signal will be sent out to the bus */
                        /* after receiveing one data byte */ 
  IIC2D;                /* Dummy read */
  }
}
 
 
/*********************************************************************/
/*  Main Function                                                    */
/*********************************************************************/

void main(void) {

  MCU_Init();       /* Function that initializes the MCU */         
  GPIO_Init();      /* Function that initializes the Ports of the MCU */
  IIC_configuration();  /* Function that initializes the IIC module */  
  
  EnableInterrupts; /* enable interrupts */

  for(;;) {
  
//  Delay(60000);
//  PTED = (UINT8) (counter & 0xC0);         /* Move counter value to port E */
//  PTCD = (UINT8) (counter & 0x3F);         /* Move counter value to port C */
//  counter++;         /* Increment counter */

  if (PTHD_PTHD7 == 0) {
 
  while (PTHD_PTHD7 ==0);  /* Wait while pin is low */
  
 	while (IIC2C1_MST == 1); /* Wait untill IIC is stopped */
 	Master_Transmit(1,1);		 /* Initialize to Transmit */
  } 
  
  else {
  }
  while (IIC2C1_MST == 1); /* Wait untill IIC is stopped */
 	
  Master_Receive();
  
  Delay(60000);
  PTED = (UINT8) (counter & 0xC0);         /* Move counter value to port E */
  PTCD = (UINT8) (counter & 0x3F);         /* Move counter value to port C */
  counter++;         /* Increment counter */

  } /* loop forever */
  /* please make sure that you never leave this function */
}                                    


/*********************************************************************/
/*  Interrupt Service Routine                                        */
/*********************************************************************/

interrupt VectorNumber_Viicx void IIC_ISR(void) {

  IIC2S_IICIF = 1;             /* Clear Interrupt Flag */
  if (IIC2C1_MST)             /* Master or Slave? */
  {
  
/***************************** Master **********************************/
  
	  if (IIC2C1_TX)            /* Transmit or Receive? */
	  {                         
  /********************* Transmit ***********************/			
			
			if (last_byte) {            /* Is the Last Byte? */
				         					 
				IIC2C1_MST = 0;           /* Generate a Stop */
			}
			
			else if (last_byte != 1) {
				         					 
			  if (IIC2S_RXAK) {         /* Check for ACK */
				  IIC2C1_MST = 0;         /* No ACk Generate a Stop */
			    } 
			
			  else if (!IIC2S_RXAK) {
				         			 
			    if (add_cycle) {        /* Is Address Cycle finished? Master done addressing Slave? */
			      add_cycle = 0;        /* Clear Add cycle */
			      IIC2C1_TX = 0;        /* Switch to RX mode */
			      IIC2D;                /* Dummy read from Data Register */
			    }
			
			  else if (add_cycle != 1) {
				         			 	 	 
				  IIC2D = counter;       /* Transmit Data */
				  count++;
				     			 	 
				    if (count == bytes_to_trans) {
				         			 	 
				      last_byte = 1;
				    }
			  }
			  }
			}
	  }
      
    else {
				 
  /********************* Receive *************************/
			 
      if (last_byte_to_rec == 1) {
				 
			  IIC2C1_MST = 0;         /* Last byte to be read? */
			  Master_Read_and_Store();
			}	 
			
			else if (last_byte_to_rec == 2) {   /* Second to last byte to be read? */
			
			  last_byte_to_rec = 1;
			  IIC2C1_TXAK = 1;        /* This sets up a NACK */
			  Master_Read_and_Store();
			}	 
			
			else {
			
			Master_Read_and_Store();
			}
    }
  }

  else {

/***************************** Slave **********************************/

    if (IIC2S_ARBL) {

      IIC2S_ARBL = 1;
      if (IIC2S_IAAS) {         /* Check For Address Match */
        count = 0;
  			SRW();
      }
    }
    
    else {

	    if (IIC2S_IAAS) {         /* Arbitration not Lost */
	 		  count = 0;
	 			SRW();
	    }
	    
	    else {
	 		
	 		  if (IIC2C1_TX) {        /* Check for rec ACK */
	 		 				
	 		 	  if (!IIC2S_RXAK) {    /* ACK Recieved */
	 		 				
	 		 			IIC2D = IIC_TX_Data[count];
	 		 			count++;
	 		 	  }
	 		 	  
	 		 	  else {
	 		 				
	 		 		  IIC2C1_TX = 0;
	 		 			IIC2D;
	 		 	  }

	 		 } 
	 		 
	 		 else {
	 		 
	 		  Slave_Read_and_Store();
	 		 }
	    }
    }
  }
}

